/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn;

import OreSpawn.MashupBiome;
import dangerzone.Chunk;
import dangerzone.CreatureTypes;
import dangerzone.Dimensions;
import dangerzone.World;
import dangerzone.biomes.Biome;
import dangerzone.biomes.BiomeManager;
import dangerzone.threads.SpawnerThread;

public class MashupBiomeManager
extends BiomeManager {
    public int getWhichBiome(int x, int y, int z) {
        MashupBiome mymashb = (MashupBiome)this.biomes[this.getWhichBiomeLocal(x, y, z)];
        if (mymashb == null) {
            return 0;
        }
        BiomeManager bm = Dimensions.getBiomeManager((int)mymashb.dim);
        if (bm == null) {
            return 0;
        }
        return bm.getWhichBiome(x, y, z);
    }

    public int getWhichBiomeLocal(int x, int y, int z) {
        if (this.nregistered < 2) {
            return 0;
        }
        int highest = 0;
        float highval = -999.0f;
        float curval = -999.0f;
        int i = 0;
        while (i < this.nregistered) {
            curval = this.getValueForBiome(i, x, y, z);
            if (curval > highval) {
                highval = curval;
                highest = i;
            }
            ++i;
        }
        return highest;
    }

    public Biome getBiomeForChunk(Chunk c, int d, int x, int y, int z) {
        MashupBiome mymashb = (MashupBiome)this.biomes[this.getWhichBiomeLocal(x, y, z)];
        if (mymashb == null) {
            return null;
        }
        BiomeManager bm = Dimensions.getBiomeManager((int)mymashb.dim);
        if (bm == null) {
            return null;
        }
        return bm.biomes[bm.getWhichBiome(x, y, z)];
    }

    public void decorate(World w, int d, Chunk c, int x, int y, int z) {
        Biome myb = c.mybiome;
        MashupBiome mymashb = (MashupBiome)this.biomes[this.getWhichBiomeLocal(x, y, z)];
        if (mymashb == null) {
            return;
        }
        if (myb == null) {
            BiomeManager bm = Dimensions.getBiomeManager((int)mymashb.dim);
            if (bm == null) {
                return;
            }
            myb = bm.biomes[bm.getWhichBiome(x, y, z)];
        }
        if (myb == null) {
            return;
        }
        String tmp = Dimensions.DimensionArray[d].uniquename;
        Dimensions.DimensionArray[d].uniquename = Dimensions.DimensionArray[mymashb.dim].uniquename;
        if (c.mybiome == null) {
            c.mybiome = myb;
        }
        w.decorate(w, d, myb, x >> 4, z >> 4);
        myb.decorate(w, d, c, x >> 4, z >> 4);
        SpawnerThread.doSpawnChunk((Chunk)c, (World)w, (int)d, (int)x, (int)z, (int)CreatureTypes.PERMANENT);
        Dimensions.DimensionArray[d].uniquename = tmp;
    }

    public void generate(World w, int d, Biome b, Chunk c, int cx, int cz) {
        int j;
        int[][] dirtlevelmap = new int[16][16];
        int[][] stonelevelmap = new int[16][16];
        int[][] bottomlevelmap = new int[16][16];
        b.generateheightmaps(w, d, c, cx, cz, dirtlevelmap, stonelevelmap, bottomlevelmap);
        int mergedist = 1;
        int smoothdist = 10;
        Boolean doit = false;
        int i = -mergedist;
        while (i <= mergedist) {
            j = -mergedist;
            while (j <= mergedist) {
                if (i != 0 || j != 0) {
                    Biome tb = w.getBiome(d, cx + i << 4, 0, cz + j << 4);
                    if (tb == null) {
                        doit = true;
                        break;
                    }
                    if (!tb.uniquename.equals(b.uniquename)) {
                        doit = true;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (doit.booleanValue()) {
            int n;
            int m;
            int[][] dirtarray = new int[16 * (2 * mergedist + 1)][16 * (2 * mergedist + 1)];
            int[][] stonearray = new int[16 * (2 * mergedist + 1)][16 * (2 * mergedist + 1)];
            int[][] bottomarray = new int[16 * (2 * mergedist + 1)][16 * (2 * mergedist + 1)];
            int[][] tdirt = new int[16][16];
            int[][] tstone = new int[16][16];
            int[][] tbottom = new int[16][16];
            i = 0;
            while (i < 16) {
                j = 0;
                while (j < 16) {
                    dirtarray[i + 16 * mergedist][j + 16 * mergedist] = dirtlevelmap[i][j];
                    stonearray[i + 16 * mergedist][j + 16 * mergedist] = stonelevelmap[i][j];
                    bottomarray[i + 16 * mergedist][j + 16 * mergedist] = bottomlevelmap[i][j];
                    ++j;
                }
                ++i;
            }
            i = -mergedist;
            while (i <= mergedist) {
                j = -mergedist;
                while (j <= mergedist) {
                    if (i != 0 || j != 0) {
                        Biome tb = w.getBiome(d, cx + i << 4, 0, cz + j << 4);
                        if (tb == null) {
                            m = 0;
                            while (m < 16) {
                                n = 0;
                                while (n < 16) {
                                    dirtarray[m + (i + mergedist) * 16][n + (j + mergedist) * 16] = 0;
                                    stonearray[m + (i + mergedist) * 16][n + (j + mergedist) * 16] = 0;
                                    bottomarray[m + (i + mergedist) * 16][n + (j + mergedist) * 16] = 0;
                                    ++n;
                                }
                                ++m;
                            }
                        } else {
                            tb.generateheightmaps(w, d, null, cx + i, cz + j, tdirt, tstone, tbottom);
                            m = 0;
                            while (m < 16) {
                                n = 0;
                                while (n < 16) {
                                    dirtarray[m + (i + mergedist) * 16][n + (j + mergedist) * 16] = tdirt[m][n];
                                    stonearray[m + (i + mergedist) * 16][n + (j + mergedist) * 16] = tstone[m][n];
                                    bottomarray[m + (i + mergedist) * 16][n + (j + mergedist) * 16] = tbottom[m][n];
                                    ++n;
                                }
                                ++m;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < 16) {
                j = 0;
                while (j < 16) {
                    dirtlevelmap[i][j] = 0;
                    stonelevelmap[i][j] = 0;
                    bottomlevelmap[i][j] = 0;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < 16) {
                j = 0;
                while (j < 16) {
                    m = -smoothdist;
                    while (m <= smoothdist) {
                        n = -smoothdist;
                        while (n <= smoothdist) {
                            int[] nArray = dirtlevelmap[i];
                            int n2 = j;
                            nArray[n2] = nArray[n2] + dirtarray[i + mergedist * 16 + m][j + mergedist * 16 + n];
                            int[] nArray2 = stonelevelmap[i];
                            int n3 = j;
                            nArray2[n3] = nArray2[n3] + stonearray[i + mergedist * 16 + m][j + mergedist * 16 + n];
                            int[] nArray3 = bottomlevelmap[i];
                            int n4 = j;
                            nArray3[n4] = nArray3[n4] + bottomarray[i + mergedist * 16 + m][j + mergedist * 16 + n];
                            ++n;
                        }
                        ++m;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < 16) {
                j = 0;
                while (j < 16) {
                    int[] nArray = dirtlevelmap[i];
                    int n5 = j;
                    nArray[n5] = nArray[n5] / ((smoothdist * 2 + 1) * (smoothdist * 2 + 1));
                    int[] nArray4 = stonelevelmap[i];
                    int n6 = j;
                    nArray4[n6] = nArray4[n6] / ((smoothdist * 2 + 1) * (smoothdist * 2 + 1));
                    int[] nArray5 = bottomlevelmap[i];
                    int n7 = j++;
                    nArray5[n7] = nArray5[n7] / ((smoothdist * 2 + 1) * (smoothdist * 2 + 1));
                }
                ++i;
            }
        }
        b.generate(w, d, c, cx, cz, dirtlevelmap, stonelevelmap, bottomlevelmap);
    }
}

